% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_smooths}
\alias{plot_smooths}
\title{Plot GAM smooths.}
\usage{
plot_smooths(
  model,
  series,
  comparison = NULL,
  facet_terms = NULL,
  conditions = NULL,
  exclude_random = TRUE,
  exclude_terms = NULL,
  series_length = 25,
  split = NULL,
  sep = "\\\\.",
  transform = NULL,
  ci_z = 1.96,
  time_series
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{series}{An unquoted expression indicating the model term that defines the series on which smoothing is applied. This is the term that is displayed on the x-axis when plotting.}

\item{comparison}{An unquoted expression indicating the model term for which the comparison will be plotted.}

\item{facet_terms}{An unquoted formula with the terms used for faceting.}

\item{conditions}{A list of quosures with \code{quos} specifying the levels to plot from the model terms not among \code{series}, \code{comparison}, or \code{facet_terms}.}

\item{exclude_random}{Whether to exclude random smooths (the default is \code{TRUE}).}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names should be given as they appear in the model summary (for example, \code{"s(x0,x1)"}).}

\item{series_length}{An integer indicating how many values along the time series to use for predicting the outcome term.}

\item{split}{Columns to separate as a named list.}

\item{sep}{Separator between columns (default is \code{"\\."}, which is the default with \code{}). If character, it is interpreted as a regular expression.}

\item{transform}{Function used to transform the fitted values (useful for getting plots on the response scale).}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for 95 percent CI).}

\item{time_series}{Deprecated, use \code{series} instead.}
}
\value{
A \code{\link[ggplot2]{ggplot} object.}
}
\description{
It plots the smooths from the estimates of a \link[mgcv]{gam} or \link[mgcv]{bam} object.
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac) + s(x0), data = data)

plot_smooths(model, x2, fac)

# alternative model specification
model <- gam(y ~ s(fac, bs = "re") + s(x2) + s(x2, by = fac) + s(x0), data = data)
plot_smooths(model, x2, fac)

# For details, see vignette
\dontrun{
vignette("plot-smooths", package = "tidymv")
}

}
