% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict_gam}
\alias{predict_gam}
\title{Get all predictions from a GAM model.}
\usage{
predict_gam(model, exclude_terms = NULL, length_out = 50,
  values = NULL)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names should be given as they appear in the model summary (for example, \code{"s(x0,x1)"}).}

\item{length_out}{An integer indicating how many values along the numeric predictors to use for predicting the outcome term (the default is \code{50}).}

\item{values}{User supplied values for numeric terms as a named list.}
}
\value{
A tibble with predictions from a a \link[mgcv]{gam} or \link[mgcv]{bam} model.
}
\description{
It returns a tibble with the predictions from all the terms in a \link[mgcv]{gam} or \link[mgcv]{bam} model.
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac) + s(x0), data = data)

# get predictions
p <- predict_gam(model)

# get predictions excluding x0 (the coefficient of x0 is set to 0)
p_2 <- predict_gam(model, exclude_terms = "s(x0)")

# get predictions with chosen values of x0

p_3 <- predict_gam(model, values = list(x0 = c(0.250599, 0.503313, 0.756028)))

}
