% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{create_lexicon}
\alias{create_lexicon}
\title{Make a lexicon for looping over in the gibbs sampler}
\usage{
create_lexicon(Cd_in, Beta_in, dtm_in, alpha, freeze_topics)
}
\arguments{
\item{Cd_in}{IntegerMatrix denoting counts of topics in documents}

\item{Beta_in}{NumericMatrix denoting probability of words in topics}

\item{dtm_in}{arma::sp_mat document term matrix}

\item{alpha}{NumericVector prior for topics over documents}

\item{freeze_topics}{bool if making predictions, set to \code{TRUE}}
}
\value{
Returns a list with five entries.

  \code{Docs} is a list of vectors. Each element is a document, and the contents
  are indices for tokens. Used as an iterator for the Gibbs sampler.
  
  \code{Zd} is a list of vectors, similar to Docs. However, its contents are topic
  assignments of each document/token pair. Used as an iterator for Gibbs
  sampling.
  
  \code{Cd} is a matrix counting the number of times each topic is sampled per
  document.
  
  \code{Cv} is a matrix counting the number of times each topic is sampled per token.
  
  \code{Ck} is a vector counting the total number of times each topic is sampled overall.
  
  \code{Cd}, \code{Cv}, and \code{Ck} are derivatives of \code{Zd}.
}
\description{
One run of the Gibbs sampler and other magic to initialize some objects.
  Works in concert with \code{\link[tidylda]{initialize_topic_counts}}.
}
\details{
Arguments ending in \code{_in} are copied and their copies modified in
  some way by this function. In the case of \code{Cd_in} and \code{Beta_in},
  the only modification is that they are converted from matrices to nested
  \code{std::vector} for speed, reliability, and thread safety. \code{dtm_in}
  is transposed for speed when looping over columns.
}
\keyword{internal}
