% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tbl_json.r
\name{tbl_json}
\alias{as.tbl_json}
\alias{as.tbl_json.character}
\alias{as.tbl_json.data.frame}
\alias{as.tbl_json.tbl_json}
\alias{is.tbl_json}
\alias{tbl_json}
\title{Combines structured JSON (as a data.frame) with remaining JSON}
\usage{
tbl_json(df, json.list, drop.null.json = FALSE)

as.tbl_json(x, ...)

\method{as.tbl_json}{tbl_json}(x, ...)

\method{as.tbl_json}{character}(x, ...)

\method{as.tbl_json}{data.frame}(x, json.column, ...)

is.tbl_json(x)
}
\arguments{
\item{df}{data.frame}

\item{json.list}{list of json lists parsed with fromJSON}

\item{drop.null.json}{drop NULL json entries from data.frame and json}

\item{x}{an object to convert into a tbl_json object}

\item{...}{other arguments}

\item{json.column}{the name of the JSON column of data in x, if x is a data.frame}
}
\description{
Combines structured JSON (as a data.frame) with remaining JSON

Note that json.list must have the same length as nrow(df), and if json.list
has any NULL elements, the corresponding rows will be removed from df. Also
note that "..JSON" is a reserved column name used internally for filtering
tbl_json objects, and so is not allowed in the data.frame names.
}

