% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_plot.R
\name{hy_plot}
\alias{hy_plot}
\title{Convenience function to plot realtime data}
\usage{
hy_plot(station_number = NULL, Parameter = c("Flow", "Level", "Suscon",
  "Load"))
}
\arguments{
\item{station_number}{A (or several) seven digit Water Survey of Canada station number.}

\item{Parameter}{Parameter of interest. Either "Flow" or "Level".}
}
\value{
A plot of recent realtime values
}
\description{
This is an easy way to visualize a single station using base R graphics. 
More complicated plotting needs should consider using \code{ggplot2}. Inputting more 
5 stations will result in very busy plots and longer load time. Legend position will
sometimes overlap plotted points.
}
\examples{
\dontrun{
## One station
hy_plot("08MF005")

## Multiple stations
hy_plot(c("07EC002","01AD003"))
}

}
