% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{estimate_diagnostic}
\alias{estimate_diagnostic}
\title{Function to calculate diagnostics based on model outputs}
\usage{
estimate_diagnostic(data, label, prediction, diag_name, params)
}
\arguments{
\item{data}{The full data frame with all auxilliary columns.}

\item{label}{The (string) column name for the labels to evaluate against.}

\item{prediction}{The (string) column name of predictions from the model to diagnose.}

\item{diag_name}{The (string) name of the diagnostic to calculate. Currently
available are "AUC", "MSE", "SL_coefs", "SL_risk", "RROC"}

\item{params}{Any other necessary options to pass to the given diagnostic.}
}
\description{
This function defines the calculations of common model diagnostics
which are available.
}
\examples{
df <- dplyr::tibble(y = rbinom(100, 1, 0.5), p = rep(0.5, 100), w = rexp(100), u = 1:100)
attr(df, "weights") <- "w"
attr(df, "identifier") <- "u"
estimate_diagnostic(df, "y", "p", "AUC")
}
\keyword{internal}
