% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint-effect-estimation.R
\name{FX.Predictor}
\alias{FX.Predictor}
\title{Predictor class for the cross-fit predictor of "partial" CATEs}
\description{
Predictor class for the cross-fit predictor of "partial" CATEs

Predictor class for the cross-fit predictor of "partial" CATEs
}
\details{
The class makes it easier to manage the K predictors for retrieving K-fold
cross-validated estimates, as well as to measure how treatment effects change
when only a single covariate is changed from its "natural" levels (in the sense
"natural" used by the direct / indirect effects literature).
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{models}}{A list of the K model fits}

\item{\code{num_splits}}{The number of folds used in cross-fitting.}

\item{\code{num_mc_samples}}{The number of samples to retrieve across the covariate space.
If num_mc_samples is larger than the sample size, then the entire dataset will be used.}

\item{\code{covariates}}{The unquoted names of the covariates used in the second-stage model.}

\item{\code{model_class}}{The model class (in the sense of \code{Model_cfg}). For instance,
a SuperLearner model will have model class "SL".}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FX.Predictor-new}{\code{FX.Predictor$new()}}
\item \href{#method-FX.Predictor-predict}{\code{FX.Predictor$predict()}}
\item \href{#method-FX.Predictor-clone}{\code{FX.Predictor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FX.Predictor-new"></a>}}
\if{latex}{\out{\hypertarget{method-FX.Predictor-new}{}}}
\subsection{Method \code{new()}}{
\code{FX.predictor} is a class which simplifies the management of a set of cross-fit
prediction models of treatment effects and provides the ability to get the "partial"
effects of particular covariates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FX.Predictor$new(models, num_splits, num_mc_samples, covariates, model_class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{models}}{A list of the K model fits.}

\item{\code{num_splits}}{Integer number of cross-fitting folds.}

\item{\code{num_mc_samples}}{Integer number of Monte-Carlo samples across the covariate
space. If this is larger than the sample size, then the whole dataset will be used.}

\item{\code{covariates}}{The unquoted names of the covariates.}

\item{\code{model_class}}{The model class (in the sense of \code{Model_cfg}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FX.Predictor-predict"></a>}}
\if{latex}{\out{\hypertarget{method-FX.Predictor-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts the PCATE surface over a particular covariate, returning a tibble with
the predicted HTE for every Monte-Carlo sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FX.Predictor$predict(data, covariate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The full dataset}

\item{\code{covariate}}{The unquoted covariate name for which to calculate predicted
treatment effects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A tibble with columns:
\itemize{
\item \code{covariate_value} - The value of the covariate of interest
\item \code{.hte} - An estimated HTE
\item \code{.id} - The identifier for the original row (which had
\code{covariate} modified to \code{covariate_value}).
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FX.Predictor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FX.Predictor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FX.Predictor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
