% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_measures.R
\name{graph_measures}
\alias{graph_measures}
\alias{graph_adhesion}
\alias{graph_assortativity}
\alias{graph_automorphisms}
\alias{graph_clique_num}
\alias{graph_clique_count}
\alias{graph_component_count}
\alias{graph_motif_count}
\alias{graph_diameter}
\alias{graph_girth}
\alias{graph_radius}
\alias{graph_mutual_count}
\alias{graph_asym_count}
\alias{graph_unconn_count}
\alias{graph_size}
\alias{graph_order}
\alias{graph_reciprocity}
\alias{graph_min_cut}
\alias{graph_mean_dist}
\alias{graph_modularity}
\title{Graph measurements}
\usage{
graph_adhesion()

graph_assortativity(attr, in_attr = NULL, directed = TRUE)

graph_automorphisms(sh = "fm")

graph_clique_num()

graph_clique_count(min = NULL, max = NULL, subset = NULL)

graph_component_count(type = "weak")

graph_motif_count(size = 3, cut.prob = rep(0, size))

graph_diameter(weights = NULL, directed = TRUE, unconnected = TRUE)

graph_girth()

graph_radius(mode = "out")

graph_mutual_count()

graph_asym_count()

graph_unconn_count()

graph_size()

graph_order()

graph_reciprocity(ignore_loops = TRUE, ratio = FALSE)

graph_min_cut(capacity = NULL)

graph_mean_dist(directed = TRUE, unconnected = TRUE)

graph_modularity(group, weights = NULL)
}
\arguments{
\item{attr}{The node attribute to measure on}

\item{in_attr}{An alternative node attribute to use for incomming node. If \code{NULL} the attribute given by \code{type} will be used}

\item{directed}{Should a directed graph be treated as directed}

\item{sh}{The splitting heuristics for the BLISS algorithm. Possible values
are: \sQuote{\code{f}}: first non-singleton cell, \sQuote{\code{fl}}: first
largest non-singleton cell, \sQuote{\code{fs}}: first smallest non-singleton
cell, \sQuote{\code{fm}}: first maximally non-trivially connected
non-singleton cell, \sQuote{\code{flm}}: first largest maximally
non-trivially connected non-singleton cell, \sQuote{\code{fsm}}: first
smallest maximally non-trivially connected non-singleton cell.}

\item{min, max}{The upper and lower bounds of the cliques to be considered.}

\item{subset}{The indexes of the nodes to start the search from (logical or integer). If provided only the cliques containing these nodes will be counted.}

\item{type}{The type of component to count, either 'weak' or 'strong'. Ignored for undirected graphs.}

\item{size}{The size of the motif, currently 3 and 4 are supported only.}

\item{cut.prob}{Numeric vector giving the probabilities that the search
graph is cut at a certain level. Its length should be the same as the size
of the motif (the \code{size} argument). By default no cuts are made.}

\item{weights}{Optional positive weight vector for calculating weighted
distances. If the graph has a \code{weight} edge attribute, then this is
used by default.}

\item{unconnected}{Logical, what to do if the graph is unconnected. If
FALSE, the function will return a number that is one larger the largest
possible diameter, which is always the number of vertices. If TRUE, the
diameters of the connected components will be calculated and the largest one
will be returned.}

\item{mode}{How should eccentricity be calculated. If \code{"out"} only outbound edges are followed. If \code{"in"} only inbound are followed. If \code{"all"} all edges are followed. Ignored for undirected graphs.}

\item{ignore_loops}{Logical. Should loops be ignored while calculating the reciprocity}

\item{ratio}{Should the old "ratio" approach from igraph < v0.6 be used}

\item{capacity}{The capacity of the edges}

\item{group}{The node grouping to calculate the modularity on}
}
\value{
A scalar, the type depending on the function
}
\description{
This set of functions provide wrappers to a number of \code{ìgraph}s graph
statistic algorithms. As for the other wrappers provided, they are intended
for use inside the \code{tidygraph} framework and it is thus not necessary to
supply the graph being computed on as the context is known. All of these
functions are guarantied to return scalars making it easy to compute with
them.
}
\section{Functions}{
\itemize{
\item \code{graph_adhesion}: Gives the minimum edge connectivity. Wraps \code{\link[igraph:edge_connectivity]{igraph::edge_connectivity()}}

\item \code{graph_assortativity}: Measures the propensity of similar nodes to be connected. Wraps \code{\link[igraph:assortativity]{igraph::assortativity()}}

\item \code{graph_automorphisms}: Calculate the number of automorphisms of the graph. Wraps \code{\link[igraph:automorphisms]{igraph::automorphisms()}}

\item \code{graph_clique_num}: Get the size of the largest clique. Wraps \code{\link[igraph:cliques]{igraph::clique_num()}}

\item \code{graph_clique_count}: Get the number of maximal cliques in the graph. Wraps \code{\link[igraph:cliques]{igraph::count_max_cliques()}}

\item \code{graph_component_count}: Count the number of unconnected componenets in the graph. Wraps \code{\link[igraph:components]{igraph::count_components()}}

\item \code{graph_motif_count}: Count the number of motifs in a graph. Wraps \code{\link[igraph:count_motifs]{igraph::count_motifs()}}

\item \code{graph_diameter}: Measures the length of the longest geodesic. Wraps \code{\link[igraph:diameter]{igraph::diameter()}}

\item \code{graph_girth}: Measrues the length of the shortest circle in the graph. Wraps \code{\link[igraph:girth]{igraph::girth()}}

\item \code{graph_radius}: Measures the smallest eccentricity in the graph. Wraps \code{\link[igraph:radius]{igraph::radius()}}

\item \code{graph_mutual_count}: Counts the number of mutually connected nodes. Wraps \code{\link[igraph:dyad_census]{igraph::dyad_census()}}

\item \code{graph_asym_count}: Counts the number of asymmetrically connected nodes. Wraps \code{\link[igraph:dyad_census]{igraph::dyad_census()}}

\item \code{graph_unconn_count}: Counts the number of unconnected node pairs. Wraps \code{\link[igraph:dyad_census]{igraph::dyad_census()}}

\item \code{graph_size}: Counts the number of edges in the graph. Wraps \code{\link[igraph:gsize]{igraph::gsize()}}

\item \code{graph_order}: Counts the number of nodes in the graph. Wraps \code{\link[igraph:gorder]{igraph::gorder()}}

\item \code{graph_reciprocity}: Measures the proportion of mutual connections in the graph. Wraps \code{\link[igraph:reciprocity]{igraph::reciprocity()}}

\item \code{graph_min_cut}: Calculates the minimum number of edges to remove in order to split the graph into two clusters. Wraps \code{\link[igraph:min_cut]{igraph::min_cut()}}

\item \code{graph_mean_dist}: Calculates the mean distance between all node pairs in the graph. Wraps \code{\link[igraph:distances]{igraph::mean_distance()}}

\item \code{graph_modularity}: Calculates the modularity of the graph contingent on a provided node grouping
}}

\examples{
# Use e.g. to modify computations on nodes and edges
create_notable('meredith') \%>\%
  activate(nodes) \%>\%
  mutate(rel_neighbors = centrality_degree()/graph_order())
}
