% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{with_graph}
\alias{with_graph}
\title{Evaluate a tidygraph algorithm in the context of a graph}
\usage{
with_graph(graph, expr)
}
\arguments{
\item{graph}{The \code{tbl_graph} to use as context}

\item{expr}{The expression to evaluate}
}
\value{
The value of \code{expr}
}
\description{
All tidygraph algorithms are meant to be called inside tidygraph verbs such
as \code{mutate()}, where the graph that is currently being worked on is known and
thus not needed as an argument to the function. In the off chance that you
want to use an algorithm outside of the tidygraph framework you can use
\code{with_graph()} to set the graph context temporarily while the algorithm is
being evaluated.
}
\examples{
gr <- play_erdos_renyi(10, 0.3)

with_graph(gr, centrality_degree())

}
