% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_dt.R
\name{filter_dt}
\alias{filter_dt}
\title{Filter entries in data.frame}
\usage{
filter_dt(.data, ...)
}
\arguments{
\item{.data}{data.frame}

\item{...}{List of variables or name-value pairs of summary/modifications
functions.}
}
\value{
data.table
}
\description{
Choose rows where conditions are true.
}
\examples{
iris \%>\% filter_dt(Sepal.Length > 7)
iris \%>\% filter_dt(Sepal.Length == max(Sepal.Length))

# comma is not supported in tidyfst after v0.9.8
# which means you can't use:
\dontrun{
 iris \%>\% filter_dt(Sepal.Length > 7, Sepal.Width > 3)
}
# use following code instead
iris \%>\% filter_dt(Sepal.Length > 7 & Sepal.Width > 3)

}
\seealso{
\code{\link[dplyr]{filter}}
}
