% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpoint_options.R
\name{breakpoint_options}
\alias{breakpoint_options}
\title{Create Breakpoint Options for Portfolio Sorting}
\usage{
breakpoint_options(
  n_portfolios = NULL,
  percentiles = NULL,
  breakpoint_exchanges = NULL,
  smooth_bunching = FALSE,
  ...
)
}
\arguments{
\item{n_portfolios}{Integer, optional. The number of portfolios to create. Must be a
positive integer. If not provided, defaults to \code{NULL}.}

\item{percentiles}{Numeric vector, optional. A vector of percentile thresholds for
defining breakpoints. Each value should be between 0 and 1. If not provided, defaults
to \code{NULL}.}

\item{breakpoint_exchanges}{Character, optional. A non-empty string specifying the
exchange for which the breakpoints apply. If not provided, defaults to \code{NULL}.}

\item{smooth_bunching}{Logical, optional. Indicates whether smooth bunching should
be applied. Defaults to \code{FALSE}.}

\item{...}{Additional optional arguments. These will be captured in the resulting
structure as a list.}
}
\value{
A list of class \code{"tidyfinance_breakpoint_options"} containing the provided
breakpoint options, including any additional arguments passed via \code{...}.
}
\description{
This function generates a structured list of options for defining breakpoints in
portfolio sorting. It includes parameters for the number of portfolios, percentile
thresholds, exchange-specific breakpoints, and smooth bunching, along with additional
optional parameters.
}
\examples{
breakpoint_options(
  n_portfolios = 5,
  percentiles = c(0.2, 0.4, 0.6, 0.8),
  breakpoint_exchanges = "NYSE",
  smooth_bunching = TRUE,
  custom_threshold = 0.5,
  another_option = "example"
)

}
