% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_means.R
\name{k_means}
\alias{k_means}
\title{K-Means}
\usage{
k_means(mode = "partition", engine = "stats", num_clusters = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "partition".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"stats"}.}

\item{num_clusters}{Positive integer, number of clusters in model.}
}
\value{
A \code{k_means} cluster specification.
}
\description{
\code{k_means()} defines a model that fits clusters based on distances to a number
of centers. This definition doesn't just include K-means, but includes
models like K-prototypes.

There are different ways to fit this model, and the method of estimation is
chosen by setting the model engine. The engine-specific pages for this model
are listed below.
\itemize{
\item \link[=details_k_means_stats]{stats}: Classical K-means
\item \link[=details_k_means_ClusterR]{ClusterR}: Classical K-means
\item \link[=details_k_means_klaR]{klaR}: K-Modes
\item \link[=details_k_means_clustMixType]{clustMixType}: K-prototypes
}
}
\details{
\subsection{What does it mean to predict?}{

For a K-means model, each cluster is defined by a location in the predictor
space. Therefore, prediction in tidyclust is defined by calculating which
cluster centroid an observation is closest too.
}
}
\examples{
# Show all engines
modelenv::get_from_env("k_means")

k_means()
}
