% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_variables.R
\name{load_variables}
\alias{load_variables}
\title{Load variables from a decennial Census or American Community Survey dataset to search in R}
\usage{
load_variables(
  year,
  dataset = c("sf1", "sf2", "sf3", "sf4", "pl", "dhc", "dp", "ddhca", "as", "gu", "mp",
    "vi", "acsse", "dpas", "dpgu", "dpmp", "dpvi", "dhcvi", "dhcgu", "dhcvi", "dhcas",
    "acs1", "acs3", "acs5", "acs1/profile", "acs3/profile", "acs5/profile",
    "acs1/subject", "acs3/subject", "acs5/subject", "acs1/cprofile", "acs5/cprofile",
    "sf2profile", "sf3profile", "sf4profile", "aian", "aianprofile", "cd110h", "cd110s",
    "cd110hprofile", "cd110sprofile", "sldh", "slds", "sldhprofile", "sldsprofile",
    "cqr", "cd113", "cd113profile", 
     "cd115", "cd115profile", "cd116", "plnat",
    "cd118"),
  cache = FALSE
)
}
\arguments{
\item{year}{The year for which you are requesting variables. Either the year
or endyear of the decennial Census or ACS sample. 5-year ACS data is
available from 2009 through 2020. 1-year ACS data is available from 2005
through 2021, with the exception of 2020.}

\item{dataset}{The dataset name as used on the Census website.  See the Details in this documentation for a full list of dataset names.}

\item{cache}{Whether you would like to cache the dataset for future access,
or load the dataset from an existing cache. Defaults to FALSE.}
}
\value{
A tibble of variables from the requested dataset.
}
\description{
Finding the right variables to use with \code{get_decennial()} or \code{get_acs()} can be challenging; \code{load_variables()} attempts to make this easier for you.  Choose a year and a dataset to search for variables; those variables will be loaded from the Census website as an R data frame.  It is recommended that RStudio users use the \code{View()} function to interactively browse and filter these variables to find the right variables to use.
}
\details{
\code{load_variables()} returns three columns by default: \code{name}, which is the Census ID code to be supplied to the \code{variables} parameter in \code{get_decennial()} or \code{get_acs()}; \code{label}, which is a detailed description of the variable; and \code{concept}, which provides information about the table that a given variable belongs to.  For 5-year ACS detailed tables datasets, a fourth column, \code{geography}, tells you the smallest geography at which a given variable is available.

Datasets available are as follows: "sf1", "sf2", "sf3", "sf4", "pl", "dhc", "dp",
"dhca", "ddhca", "as", "gu", "mp", "vi", "acsse",
"dpas", "dpgu", "dpmp", "dpvi",
"dhcvi", "dhcgu", "dhcvi", "dhcas",
"acs1", "acs3", "acs5", "acs1/profile",
"acs3/profile", "acs5/profile", "acs1/subject", "acs3/subject",
"acs5/subject", "acs1/cprofile", "acs5/cprofile",
"sf2profile", "sf3profile",
"sf4profile", "aian", "aianprofile",
"cd110h", "cd110s", "cd110hprofile", "cd110sprofile", "sldh",
"slds", "sldhprofile", "sldsprofile", "cqr",
"cd113", "cd113profile", "cd115", "cd115profile", "cd116", "cd118", and
"plnat".
}
\examples{
\dontrun{
v15 <- load_variables(2015, "acs5", cache = TRUE)
View(v15)
}
}
