% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_heatmap.R
\name{cor_heatmap}
\alias{cor_heatmap}
\title{Create correlation heatmaps of taxa and another continuous variable}
\usage{
cor_heatmap(
  micro_set,
  table,
  ...,
  y = clr,
  method = c("pearson", "kendall", "spearman"),
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  subtitle = NULL,
  legend_title = NULL,
  low_grad,
  high_grad
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{The OTU table}

\item{...}{Continuous variables of interest}

\item{y}{The taxa information: cts, ra, etc. The centered log ratio (clr) is recommended.}

\item{method}{Correlation type; must be supported by \code{\link[stats]{cor}}. By default it is "spearman" to use with clr. If you'd like to use taxa ra, it is recommend you switch to Kendall's correlation to account for the large number of ties common in taxa ra (lots of 0s)}

\item{main}{Plot title}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{subtitle}{Plot label}

\item{legend_title}{Title for the legend}

\item{low_grad}{Colors for the corelation magnitude. Will be fed into scale_fill_gradient}

\item{high_grad}{Colors for the corelation magnitude. Will be fed into scale_fill_gradient}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
Calculated the correlation between a specified continuous variable and some taxa measure. Correlation type and taxa measure (count, relative abundance, etc.) can be specified by the user but is "spearman" and relative abundance, respectively, by default
}
\details{
The output will give gray columns if there are missing values in the supplied continuous variable
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)
otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

set \%>\% cor_heatmap(table = "Class", gestational_age, weight)
}
