% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_profiles.R
\name{estimate_profiles}
\alias{estimate_profiles}
\title{Estimate parameters for profiles for a specific solution}
\usage{
estimate_profiles(df, ..., n_profiles, variances = "equal",
  covariances = "zero", to_return = "tibble", model = NULL,
  center_raw_data = FALSE, scale_raw_data = FALSE,
  return_posterior_probs = TRUE, return_orig_df = FALSE,
  prior_control = FALSE, print_which_stats = "some")
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles}{the number of profiles (or mixture components) to be estimated}

\item{variances}{how the variable variances are estimated; defaults to "equal" (to be constant across profiles); other option is "varying" (to be varying across profiles)}

\item{covariances}{how the variable covariances are estimated; defaults to "zero" (to not be estimated, i.e. for the covariance matrix to be diagonal); other options are "varying" (to be varying across profiles) and "equal" (to be constant across profiles)}

\item{to_return}{character string for either "tibble" (or "data.frame") or "mclust" if "tibble" is selected, then data with a column for profiles is returned; if "mclust" is selected, then output of class mclust is returned}

\item{model}{which model to estimate (DEPRECATED; use variances and covariances instead)}

\item{center_raw_data}{logical for whether to center (M = 1) the raw data (before clustering); defaults to FALSE}

\item{scale_raw_data}{logical for whether to scale (SD = 1) the raw data (before clustering); defaults to FALSE}

\item{return_posterior_probs}{TRUE or FALSE (only applicable if to_return == "tibble"); whether to include posterior probabilities in addition to the posterior profile classification; defaults to TRUE}

\item{return_orig_df}{TRUE or FALSE (if TRUE, then the entire data.frame is returned; if FALSE, then only the variables used in the model are returned)}

\item{prior_control}{whether to include a regularizing prior; defaults to false}

\item{print_which_stats}{if set to "some", prints (as a message) the log-likelihood, BIC, and entropy; if set to "all", prints (as a message) all information criteria and other statistics about the model; if set to any other values, then nothing is printed}
}
\value{
either a tibble or a ggplot2 plot of the BIC values for the explored models
}
\description{
Estimate parameters for profiles for a specific solution
}
\details{
Creates profiles (or estimates of the mixture components) for a specific mclust model in terms of the specific number of mixture components and the structure of the residual covariance matrix
}
\examples{
estimate_profiles(iris,
    Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
    n_profiles = 3)
}
