% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{glimpse}
\alias{glimpse}
\title{Get a glimpse of your data}
\usage{
glimpse(x, width = NULL, ...)
}
\arguments{
\item{x}{An object to glimpse at.}

\item{width}{Width of output: defaults to the setting of the option
\code{tibble.width} (if finite) or the width of the console.}

\item{...}{Unused, for extensibility.}
}
\value{
x original x is (invisibly) returned, allowing \code{glimpse()} to be
used within a data pipe line.
}
\description{
\lifecycle{maturing}

\code{glimpse()} is like a transposed version of \code{print()}:
columns run down the page, and data runs across.
This makes it possible to see every column in a data frame.
It's a little like \code{\link[=str]{str()}} applied to a data frame
but it tries to show you as much data as possible.
(And it always shows the underlying data, even when applied
to a remote data source.)

This generic will be moved to \pkg{pillar}, and reexported from there
as soon as it becomes available.
}
\section{S3 methods}{

\code{glimpse} is an S3 generic with a customised method for \code{tbl}s and
\code{data.frames}, and a default method that calls \code{\link[=str]{str()}}.
}

\examples{
glimpse(mtcars)

if (requireNamespace("nycflights13", quietly = TRUE)) {
  glimpse(nycflights13::flights)
}
}
