% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\name{subsetting}
\alias{subsetting}
\alias{[[.tbl_df}
\alias{$.tbl_df}
\alias{[.tbl_df}
\title{Subsetting tibbles}
\usage{
\method{[[}{tbl_df}(x, i, j, ..., exact = TRUE)

\method{$}{tbl_df}(x, name)

\method{[}{tbl_df}(x, i, j, drop = FALSE)
}
\arguments{
\item{x}{data frame.}

\item{i, j}{Row and column indices. If \code{j} is omitted, \code{i} is used as column index.}

\item{...}{Ignored.}

\item{exact}{Ignored, with a warning.}

\item{name}{
    A literal character string or a \link{name} (possibly \link{backtick}
    quoted).}

\item{drop}{Coerce to a vector if fetching one column via \code{tbl[, j]} .
Default \code{FALSE}, ignored when accessing a column via \code{tbl[j]} .}
}
\description{
Accessing columns, rows, or cells via \code{$}, \code{[[}, or \code{[} is mostly similar to
\link[base:Extract.data.frame]{regular data frames}. However, the
behavior is different for tibbles and data frames in some cases:
\itemize{
\item \code{[} always returns a tibble by default, even if
only one column is accessed.
\item Partial matching of column names with \code{$} and \code{[[} is not supported, a
warning is given and \code{NULL} is returned.
}

Unstable return type and implicit partial matching can lead to surprises and
bugs that are hard to catch. If you rely on code that requires the original
data frame behavior, coerce to a data frame via \code{\link[=as.data.frame]{as.data.frame()}}.
}
\details{
For better compatibility with older code written for regular data frames,
\code{[} supports a \code{drop} argument which defaults to \code{FALSE}.
New code should use \code{[[} to turn a column into a vector.
}
\examples{
df <- data.frame(a = 1:3, bc = 4:6)
tbl <- tibble(a = 1:3, bc = 4:6)

# Subsetting single columns:
df[, "a"]
tbl[, "a"]
tbl[, "a", drop = TRUE]
as.data.frame(tbl)[, "a"]

# Subsetting single rows with the drop argument:
df[1, , drop = TRUE]
tbl[1, , drop = TRUE]
as.list(tbl[1, ])

# Accessing non-existent columns:
df$b
tbl$b

df[["b", exact = FALSE]]
tbl[["b", exact = FALSE]]

df$bd <- c("n", "e", "w")
tbl$bd <- c("n", "e", "w")
df$b
tbl$b

df$b <- 7:9
tbl$b <- 7:9
df$b
tbl$b

# Identical behavior:
tbl[1, ]
tbl[1, c("bc", "a")]
tbl[, c("bc", "a")]
tbl[c("bc", "a")]
tbl["a"]
tbl$a
tbl[["a"]]
}
