% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_hodograph.R
\name{sounding_hodograph}
\alias{sounding_hodograph}
\title{Plot hodograph based on rawinsonde data}
\usage{
sounding_hodograph(
  ws,
  wd,
  altitude,
  max_hght = 12000,
  max_speed = 25,
  lab_hghts = c(0, 1, 3, 6, 9, 12),
  close_par = TRUE,
  ...
)
}
\arguments{
\item{ws}{wind speed [knots]}

\item{wd}{wind direction [azimuth in degrees]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) altitude [m]}

\item{max_hght}{maximum altitude [km] to be considered on the hodograph, 12 km used by default}

\item{max_speed}{displayed range of the drawn hodograph [m/s], 25 m/s used as default}

\item{lab_hghts}{height labels [km] to be drawn on the hodograph, 0, 1, 3, 6, 9, 12 used by default; NULL for skipping labels}

\item{close_par}{if plot will be modified in next steps storing par settings is needed. This logical argument is turned on by default. If you want to modify Skew-T plot in next step set it to FALSE}

\item{...}{other graphical parameters to be used with plot() function}
}
\value{
hodograph plot
}
\description{
Plot rawinsonde hodograph to show changes in wind speed and direction with height
}
\examples{
chanhassen = get_sounding(wmo_id = 72649, yy = 2001, mm = 5, dd = 10, hh = 00)
sounding_hodograph(ws = chanhassen$ws, wd = chanhassen$wd, 
                   altitude = chanhassen$altitude,max_speed = 40)
title("Chanhasses - 10 May 2001, 00:00 UTC")
}
