% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_and_summary.R
\name{plot.ithreshpred}
\alias{plot.ithreshpred}
\title{Plot diagnostics an ithreshpred object}
\usage{
\method{plot}{ithreshpred}(x, y, ..., ave_only = FALSE,
  add_best = FALSE)
}
\arguments{
\item{x}{an object of class "ithreshpred", a result of a call to
\code{\link{ithresh}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to
\code{\link[revdbayes]{plot.evpred}}.}

\item{ave_only}{A logical scalar.  Only relevant if
\code{\link{predict.ithresh}} was called with \code{which_u = "all"}.
If \code{TRUE} then plot only
a curve for the weighted average over multiple training thresholds.
If \code{FALSE} then also plot a curve for each training threshold.}

\item{add_best}{A logical scalar.  If \code{TRUE} then the best
threshold, as judged using the validation threshold selected using the
argument \code{which_v} supplied to \code{\link{predict.ithresh}}, is
highlighted by plotting it with a different line style.}
}
\value{
A list containing the graphical parameters using in producing the
  plot including any arguments supplied via ... is returned (invisibly).
}
\description{
\code{plot} method for class "ithreshpred".  Produces plots to summarise
the predictive inferences made by \code{\link{predict.ithresh}}.
}
\details{
\emph{Single threshold case}, where
  \code{\link{predict.ithresh}} was called with numeric scalar
  \code{which_u} or \code{which_u = "best"}.
  \code{\link[revdbayes]{plot.evpred}} is called to produce the plot.

  \emph{Multiple threshold} case, where
  \code{\link{predict.ithresh}} was called with \code{which_u = "all"}.
  Again, \code{\link[revdbayes]{plot.evpred}} is called but now the
  estimated predictive distribution function (\code{type = "p"} used
  in the call to \code{\link{predict.ithresh}}) or density function
  (\code{type = "d"}) is plotted for each of the training thresholds
  (grey lines) as is the result of the weighted average over the
  different training thresholds (black line).
  If graphical parameters, such as \code{lty}, \code{lwd} or \code{col}
  are passed via \code{...} then the first element relates to the
  weighted average and the remaining \code{length(x$u_vec)} elements to
  the respective training thresholds in \code{u_vec}.
}
\examples{
u_vec_gom <- quantile(gom, probs = seq(0, 0.9, by = 0.05))
gom_cv <- ithresh(data = gom, u_vec = u_vec_gom, n_v = 3)

# Note: gom_cv$npy contains the correct value of npy (it was set in the
#       call to ithresh, via attr(gom, "npy").
#       If object$npy doesn't exist then the argument npy must be supplied
#       in the call to predict().

### Best training threshold based on the lowest validation threshold

# Predictive distribution function
npy_gom <- length(gom)/105
best_p <- predict(gom_cv, n_years = c(100, 1000))
plot(best_p)

# Predictive density function
best_d <- predict(gom_cv, type = "d", n_years = c(100, 1000))
plot(best_d)

### All thresholds plus weighted average of inferences over all thresholds

# Predictive distribution function
all_p <- predict(gom_cv, which_u = "all")
plot(all_p)

# Predictive density function
all_d <- predict(gom_cv, which_u = "all", type = "d")
plot(all_d)

### ... and highlight the best threshold

plot(all_p, add_best = TRUE)
plot(all_d, add_best = TRUE)
}
\seealso{
\code{\link{ithresh}} for threshold selection in the i.i.d. case
  based on leave-one-out cross-validation.

\code{\link{predict.ithresh}} for predictive inference for the
  largest value observed in N years.

\code{\link{plot.ithresh}} for the S3 plot method for objects of
  class \code{ithresh}.

\code{\link{summary.ithresh}} Summarizing measures of threshold
  predictive performance.
}
