% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-localization.R
\name{localization_module}
\alias{localization_module}
\title{Launch a 'shiny' application to localize electrodes}
\usage{
localization_module(
  subject_code,
  fs_path,
  ct_path = NULL,
  surfaces = "pial",
  use_141 = TRUE,
  shiny_options = list(launch.browser = TRUE),
  save_path = tempfile(pattern = "electrode", fileext = ".csv"),
  ...,
  control_presets = NULL,
  side_display = FALSE,
  controllers = list()
)
}
\arguments{
\item{subject_code}{subject code}

\item{fs_path}{the subject's 'FreeSurfer' path}

\item{ct_path}{the file path of 'CT' scans that have already been aligned
to 'T1'; must be in 'NIFTI' format}

\item{surfaces}{which surfaces to load}

\item{use_141}{whether to try 'SUMA' standard 141 surface; default is true}

\item{shiny_options}{shiny application options; see \code{options} in
\code{\link[shiny]{shinyApp}}}

\item{save_path}{a temporary file where the electrode table should be
cached; this file will be used to keep track of changes in case the
application is crashed or shutdown}

\item{...}{other parameters to pass into \code{\link{freesurfer_brain2}}}

\item{control_presets, side_display, controllers}{passed to
\code{\link{threejs_brain}}}
}
\value{
A list of \code{'ui'} elements, \code{'server'} function, and
a stand-alone \code{'app'}
}
\description{
Launch a 'shiny' application to localize electrodes
}
\examples{

# This example require N27 template brain to be installed
# see `?download_N27` for details

# using N27 to localize
fs_path <- file.path(default_template_directory(), "N27")
if(dir.exists(fs_path)){
  module <- localization_module("N27", fs_path)

  if(interactive()){
    print(module$app)
  }
}

}
