% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelize_fun.R
\name{parallelize_fun}
\alias{parallelize_fun}
\title{Parallelize a function}
\usage{
parallelize_fun(x, fun, cores = 1, export_fun = NULL, verbose = TRUE)
}
\arguments{
\item{x}{A vector or list to apply over.}

\item{fun}{The function to be applied to each element.}

\item{cores}{The number of cores to use for parallelization with \link[foreach:foreach]{foreach::foreach}.
Default is \code{1}.}

\item{export_fun}{The functions to export the function to workers.}

\item{verbose}{Whether to print progress messages.
Default is \code{TRUE}.}
}
\value{
A list of computed results.
}
\description{
Parallelize a function
}
\examples{
parallelize_fun(1:3, function(x) {
  Sys.sleep(0.2)
  x^2
})

parallelize_fun(list(1, 2, 3), function(x) {
  Sys.sleep(0.2)
  x^2
}, cores = 2)
}
