% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tomek_impl.R
\name{tomek}
\alias{tomek}
\title{Remove Tomek's links}
\usage{
tomek(df, var)
}
\arguments{
\item{df}{data.frame or tibble. Must have 1 factor variable and remaining
numeric variables.}

\item{var}{Character, name of variable containing factor variable.}
}
\value{
A data.frame or tibble, depending on type of \code{df}.
}
\description{
Removed observations that are part of tomek links.
}
\details{
All columns used in this function must be numeric with no missing data.
}
\examples{
circle_numeric <- circle_example[, c("x", "y", "class")]

res <- tomek(circle_numeric, var = "class")
}
\references{
Tomek. Two modifications of cnn. IEEE Trans. Syst. Man Cybern.,
6:769-772, 1976.
}
\seealso{
\code{\link[=step_tomek]{step_tomek()}} for step function of this method

Other Direct Implementations: 
\code{\link{adasyn}()},
\code{\link{bsmote}()},
\code{\link{nearmiss}()},
\code{\link{smotenc}()},
\code{\link{smote}()}
}
\concept{Direct Implementations}
