% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\alias{tsfeature_classifier}
\title{Fit classifiers using time-series features using a resample-based approach and get a fast understanding of performance}
\usage{
classify(
  data,
  classifier = NULL,
  train_size = 0.75,
  n_resamples = 30,
  by_set = TRUE,
  use_null = FALSE,
  seed = 123
)

tsfeature_classifier(
  data,
  classifier = NULL,
  train_size = 0.75,
  n_resamples = 30,
  by_set = TRUE,
  use_null = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{\code{feature_calculations} object containing the raw feature matrix produced by \code{theft::calculate_features}}

\item{classifier}{\code{function} specifying the classifier to fit. Should be a function with 2 arguments: \code{formula} and \code{data} containing a classifier compatible with R's \code{predict} functionality. Please note that \code{classify} z-scores data prior to modelling using the train set's information so disabling default scaling if your function uses it is recommended. Defaults to \code{NULL} which means the following linear SVM is fit: \code{classifier = function(formula, data){mod <- e1071::svm(formula, data = data, kernel = "linear", scale = FALSE, probability = TRUE)}}}

\item{train_size}{\code{numeric} denoting the proportion of samples to use in the training set. Defaults to \code{0.75}}

\item{n_resamples}{\code{integer} denoting the number of resamples to calculate. Defaults to \code{30}}

\item{by_set}{\code{Boolean} specifying whether to compute classifiers for each feature set. Defaults to \code{TRUE}. If \code{FALSE}, the function will instead find the best individually-performing features}

\item{use_null}{\code{Boolean} whether to fit null models where class labels are shuffled in order to generate a null distribution that can be compared to performance on correct class labels. Defaults to \code{FALSE}}

\item{seed}{\code{integer} to fix R's random number generator to ensure reproducibility. Defaults to \code{123}}
}
\value{
\code{list} containing a named \code{vector} of train-test set sizes, and a \code{data.frame} of classification performance results
}
\description{
Fit classifiers using time-series features using a resample-based approach and get a fast understanding of performance
}
\examples{

library(theft)

features <- theft::calculate_features(theft::simData,
  feature_set = "catch22")

classifiers <- classify(features,
  by_set = FALSE,
  n_resamples = 3)

}
\author{
Trent Henderson
}
