% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_qda_scaling.R
\name{get_qda_scaling}
\alias{get_qda_scaling}
\title{Calculates the weights of the function W described in Metodiev et al. (2025).}
\usage{
get_qda_scaling(G, sims, center = NULL)
}
\arguments{
\item{G}{number of components}

\item{sims}{n_simul x G x (u+1) array of parameters sampled from
the posterior, where
  n_simul is the number of simulations from the posterior,
  G       is the number of components,
  u       is the number of mixture component parameters
          (parameter u+1 is the mixture weight)}

\item{center}{optional, means of the mixture component parameters}
}
\value{
a named list including the weights (i.e., means and covariances)
}
\description{
Calculates the weights of the function W described in Metodiev et al. (2025).
}
\references{
Martin Metodiev, Nicholas J. Irons, Marie Perrot-Dockès,
Pierre Latouche, Adrian E. Raftery. "Easily Computed Marginal Likelihoods
for Multivariate Mixture Models Using the THAMES Estimator."
arXiv preprint arXiv:2504.21812.
}
\keyword{internal}
