% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnote_plan.R
\name{footnote_structure}
\alias{footnote_structure}
\title{Footnote Structure}
\usage{
footnote_structure(
  footnote_text,
  column_val = NULL,
  group_val = NULL,
  label_val = NULL
)
}
\arguments{
\item{footnote_text}{string with text for footnote}

\item{column_val}{string or a named list of strings which represent the column to apply the footnote to}

\item{group_val}{string or a named list of strings which represent the value of group to apply the footnote to}

\item{label_val}{string which represents the value of label to apply the footnote to}
}
\value{
footnote structure object
}
\description{
Footnote Structure
}
\examples{

# Adds a source note aka a footnote without a symbol in the table
footnote_structure <- footnote_structure(footnote_text = "Source Note")

# Adds a footnote to the 'Placebo' column
footnote_structure <- footnote_structure(footnote_text = "Text",
                               column_val = "Placebo")

# Adds a footnote to either 'Placebo' or 'Treatment groups' depending on which
# which is last to appear in the column vector
footnote_structure <- footnote_structure(footnote_text = "Text",
      column_val = list(col1 = "Placebo", col2= "Treatment groups"))

# Adds a footnote to the 'Adverse Event' label
footnote_structure <- footnote_structure("Text", label_val = "Adverse Event")
}
