% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_variable}
\alias{layer_variable}
\title{Variable Layer}
\usage{
layer_variable(object, shape, dtype = NULL, activation = NULL,
  initializer = "zeros", regularizer = NULL, constraint = NULL, ...)
}
\arguments{
\item{object}{Model or layer object}

\item{shape}{integer or integer vector specifying the shape of the output of this layer.}

\item{dtype}{TensorFlow \code{dtype} of the variable created by this layer.}

\item{activation}{An activation function.  See \code{keras::layer_dense}. Default: \code{NULL}.}

\item{initializer}{Initializer for the \code{constant} vector.}

\item{regularizer}{Regularizer function applied to the \code{constant} vector.}

\item{constraint}{Constraint function applied to the \code{constant} vector.}

\item{...}{Additional keyword arguments passed to the \code{keras::layer_dense} constructed by this layer.}
}
\value{
a Keras layer
}
\description{
Simply returns a (trainable) variable, regardless of input.
This layer implements the mathematical function \code{f(x) = c} where \code{c} is a
constant, i.e., unchanged for all \code{x}. Like other Keras layers, the constant
is \code{trainable}.  This layer can also be interpretted as the special case of
\code{layer_dense()} when the \code{kernel} is forced to be the zero matrix
(\code{tf$zeros}).
}
\seealso{
Other layers: \code{\link{layer_autoregressive}},
  \code{\link{layer_conv_1d_flipout}},
  \code{\link{layer_conv_1d_reparameterization}},
  \code{\link{layer_conv_2d_flipout}},
  \code{\link{layer_conv_2d_reparameterization}},
  \code{\link{layer_conv_3d_flipout}},
  \code{\link{layer_conv_3d_reparameterization}},
  \code{\link{layer_dense_flipout}},
  \code{\link{layer_dense_local_reparameterization}},
  \code{\link{layer_dense_reparameterization}},
  \code{\link{layer_dense_variational}}
}
\concept{layers}
