% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-methods.R
\name{tfd_kl_divergence}
\alias{tfd_kl_divergence}
\title{Computes the Kullback--Leibler divergence.}
\usage{
tfd_kl_divergence(distribution, other, name = "kl_divergence")
}
\arguments{
\item{distribution}{The distribution being used.}

\item{other}{\code{tfp$distributions$Distribution} instance.}

\item{name}{String prepended to names of ops created by this function.}
}
\value{
self$dtype Tensor with shape \verb{[B1, ..., Bn]} representing n different calculations
of the Kullback-Leibler divergence.
}
\description{
Denote this distribution by p and the other distribution by q.
Assuming p, q are absolutely continuous with respect to reference measure r,
the KL divergence is defined as:
\verb{KL[p, q] = E_p[log(p(X)/q(X))] = -int_F p(x) log q(x) dr(x) + int_F p(x) log p(x) dr(x) = H[p, q] - H[p]}
where F denotes the support of the random variable \code{X ~ p}, \code{H[., .]}
denotes (Shannon) cross entropy, and \code{H[.]} denotes (Shannon) entropy.
}
\examples{
\donttest{
  d1 <- tfd_normal(loc = c(1, 2), scale = c(1, 0.5))
  d2 <- tfd_normal(loc = c(1.5, 2), scale = c(1, 0.5))
  d1 \%>\% tfd_kl_divergence(d2)
}
}
\seealso{
Other distribution_methods: 
\code{\link{tfd_cdf}()},
\code{\link{tfd_covariance}()},
\code{\link{tfd_cross_entropy}()},
\code{\link{tfd_entropy}()},
\code{\link{tfd_log_cdf}()},
\code{\link{tfd_log_prob}()},
\code{\link{tfd_log_survival_function}()},
\code{\link{tfd_mean}()},
\code{\link{tfd_mode}()},
\code{\link{tfd_prob}()},
\code{\link{tfd_quantile}()},
\code{\link{tfd_sample}()},
\code{\link{tfd_stddev}()},
\code{\link{tfd_survival_function}()},
\code{\link{tfd_variance}()}
}
\concept{distribution_methods}
