% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_rational_quadratic_spline}
\alias{tfb_rational_quadratic_spline}
\title{A piecewise rational quadratic spline, as developed in Conor et al.(2019).}
\usage{
tfb_rational_quadratic_spline(
  bin_widths,
  bin_heights,
  knot_slopes,
  range_min = -1,
  validate_args = FALSE,
  name = NULL
)
}
\arguments{
\item{bin_widths}{The widths of the spans between subsequent knot \code{x} positions,
a floating point \code{Tensor}. Must be positive, and at least 1-D. Innermost
axis must sum to the same value as \code{bin_heights}. The knot \code{x} positions
will be a first at \code{range_min}, followed by knots at \code{range_min + cumsum(bin_widths, axis=-1)}.}

\item{bin_heights}{The heights of the spans between subsequent knot \code{y}
positions, a floating point \code{Tensor}. Must be positive, and at least
1-D. Innermost axis must sum to the same value as \code{bin_widths}. The knot
\code{y} positions will be a first at \code{range_min}, followed by knots at
\code{range_min + cumsum(bin_heights, axis=-1)}.}

\item{knot_slopes}{The slope of the spline at each knot, a floating point
\code{Tensor}. Must be positive. \code{1}s are implicitly padded for the first and
last implicit knots corresponding to \code{range_min} and \code{range_min + sum(bin_widths, axis=-1)}. Innermost axis size should be 1 less than
that of \code{bin_widths}/\code{bin_heights}, or 1 for broadcasting.}

\item{range_min}{The \code{x}/\code{y} position of the first knot, which has implicit
slope \code{1}. \code{range_max} is implicit, and can be computed as \code{range_min + sum(bin_widths, axis=-1)}. Scalar floating point \code{Tensor}.}

\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a bijector instance.
}
\description{
This transformation represents a monotonically increasing piecewise rational
quadratic function. Outside of the bounds of \code{knot_x}/\code{knot_y}, the transform
behaves as an identity function.
}
\details{
Typically this bijector will be used as part of a chain, with splines for
trailing \code{x} dimensions conditioned on some of the earlier \code{x} dimensions, and
with the inverse then solved first for unconditioned dimensions, then using
conditioning derived from those inverses, and so forth.

For each argument, the innermost axis indexes bins/knots and batch axes
index axes of \code{x}/\code{y} spaces. A \code{RationalQuadraticSpline} with a separate
transform for each of three dimensions might have \code{bin_widths} shaped
\verb{[3, 32]}. To use the same spline for each of \code{x}'s three dimensions we may
broadcast against \code{x} and use a \code{bin_widths} parameter shaped \verb{[32]}.

Parameters will be broadcast against each other and against the input
\code{x}/\code{y}s, so if we want fixed slopes, we can use kwarg \code{knot_slopes=1}.
A typical recipe for acquiring compatible bin widths and heights would be:\preformatted{nbins <- unconstrained_vector$shape[-1]
range_min <- 1
range_max <- 1
min_bin_size = 1e-2
scale <- range_max - range_min - nbins * min_bin_size
bin_widths = tf$math$softmax(unconstrained_vector) * scale + min_bin_size
}
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1906.04032}{Conor Durkan, Artur Bekasov, Iain Murray, George Papamakarios. Neural Spline Flows. \emph{arXiv preprint arXiv:1906.04032}, 2019.}
}
}

\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_affine}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_default_template}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_pad}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_real_nvp}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_transpose}()},
\code{\link{tfb_weibull_cdf}()},
\code{\link{tfb_weibull}()}
}
\concept{bijectors}
