% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{fit.tfm}
\alias{fit.tfm}
\alias{fit}
\alias{fit.um}
\title{Estimation of the ARIMA model}
\usage{
\method{fit}{tfm}(
  mdl,
  y = NULL,
  method = c("exact", "cond"),
  optim.method = "BFGS",
  show.iter = FALSE,
  fit.noise = TRUE,
  ...
)

fit(mdl, ...)

\method{fit}{um}(
  mdl,
  z = NULL,
  method = c("exact", "cond"),
  optim.method = "BFGS",
  show.iter = FALSE,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{y}{a \code{ts} object.}

\item{method}{Exact/conditional maximum likelihood.}

\item{optim.method}{the \code{method} argument of the \code{optim}
function.}

\item{show.iter}{logical value to show or hide the estimates at the
different iterations.}

\item{fit.noise}{logical. If TRUE parameters of the noise model are fixed.}

\item{...}{additional arguments.}

\item{z}{a time series.}
}
\value{
A \code{tfm} object.

An object of class "um" with the estimated parameters.
}
\description{
\code{fit} fits the univariate model to the time series z.
}
\note{
The \code{um} function estimates the corresponding ARIMA model when a time
series is provided. The \code{fit} function is useful to fit a model to
several time series, for example, in a Monte Carlo study.
}
\examples{
z <- AirPassengers
airl <- um(i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
airl <- fit(airl, z)
}
