% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_token.R
\name{split_token}
\alias{split_token}
\alias{split_token.data.frame}
\alias{split_token.default}
\title{Split Tokens}
\usage{
split_token(x, ...)

\method{split_token}{default}(x, lower = TRUE, ...)

\method{split_token}{data.frame}(x, text.var = TRUE, lower = TRUE,
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with tokens.}

\item{lower}{logical.  If \code{TRUE} the words are converted to lower case.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{split_token} tries to detect the text column with tokens.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of tokens or an expanded
\code{\link[data.table]{data.table}} with tokens split apart.
}
\description{
Split tokens.
}
\examples{
(x <- c(
    "Mr. Brown comes! He says hello. i give him coffee.",
    "I'll go at 5 p. m. eastern time.  Or somewhere in between!",
    "go there"
))
split_token(x)
split_token(x, lower=FALSE)

data(DATA)
split_token(DATA)
split_token(DATA, lower=FALSE)

## Larger data set
split_token(hamlet)
}

