% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textreg.R
\name{find.threshold.C}
\alias{find.threshold.C}
\title{Conduct permutation test on labeling to get null distribution of regularization parameter.}
\usage{
find.threshold.C(corpus, labeling, banned = NULL, R = 0,
  objective.function = 2, a = 1, verbosity = 0,
  step.verbosity = verbosity, positive.only = FALSE,
  binary.features = FALSE, no.regularization = FALSE, positive.weight = 1,
  Lq = 2, min.support = 1, min.pattern = 1, max.pattern = 100,
  gap = 0, token.type = "word", convergence.threshold = 1e-04)
}
\arguments{
\item{corpus}{A list of strings or a corpus from the \code{tm} package.}

\item{labeling}{A vector of +1/-1 or TRUE/FALSE indicating which documents are considered relevant and
which are baseline.  The +1/-1 can contain 0 whcih means drop the document.}

\item{banned}{List of words that should be dropped from consideration.}

\item{R}{Number of times to scramble labling.  0 means use given labeling and find single C value.}

\item{objective.function}{2 is hinge loss.  0 is something.  1 is something else.}

\item{a}{What percent of regularization should be L1 loss (a=1) vs L2 loss (a=0)}

\item{verbosity}{Level of output.  0 is no printed output.}

\item{step.verbosity}{Level of output for line searches.  0 is no printed output.}

\item{positive.only}{Disallow negative features if true}

\item{binary.features}{Just code presence/absence of a feature in a document rather than count of feature in document.}

\item{no.regularization}{Do not renormalize the features at all.  (Lq will be ignored.)}

\item{positive.weight}{Scale weight pf all positively marked documents by this value.  (1, i.e., no scaling) is default)   NOT FULLY IMPLEMENTED}

\item{Lq}{Rescaling to put on the features (2 is standard).  Can be from 1 up.  Values above 10 invoke an infinity-norm.}

\item{min.support}{Only consider phrases that appear this many times or more.}

\item{min.pattern}{Only consider phrases this long or longer}

\item{max.pattern}{Only consider phrases this short or shorter}

\item{gap}{Allow phrases that have wildcard words in them.  Number is how many wildcards in a row.}

\item{token.type}{"word" or "character" as tokens.}

\item{convergence.threshold}{How to decide if descent has converged.  (Will go for three steps at this threshold to check for flatness.)}
}
\value{
A list of numbers (the Cs) R+1 long.  The first number is always the C used for the _passed_ labeling.  The remainder are shuffles.
}
\description{
First determines what regularization will give null model on labeling.  Then permutes labeling
repeatidly, recording what regularization will give null model for permuted labeling.
This allows for permutation-style inference on the relationship of the labeling to the text, and
allows for appropriate selection of the tuning parameter.
}
\details{
Important: use the same parameter values as used with the original textreg call!
}
\examples{
data( testCorpora )
find.threshold.C( testCorpora$testI$corpus, testCorpora$testI$labelI, c(), R=5, verbosity=1 )
}
