% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rtf.R
\name{read_rtf}
\alias{read_rtf}
\title{Read a Rich Text Format Content}
\usage{
read_rtf(file, skip = 0, remove.empty = TRUE, trim = TRUE, ...)
}
\arguments{
\item{file}{A path to a RTF file.}

\item{skip}{The number of lines to skip.}

\item{remove.empty}{logical.  If \code{TRUE} empty elements in the vector are
removed.}

\item{trim}{logical.  If \code{TRUE} the leading/training white space is
removed.}

\item{...}{Other arguments passed to \code{\link[striprtf:read_rtf]{striprtf::read_rtf()}}.}
}
\value{
Returns a character vector.
}
\description{
A wrapper for \code{\link[striprtf:read_rtf]{striprtf::read_rtf()}} to read RTFs
}
\examples{
\dontrun{
rtf_dat <- read_rtf(
    'https://raw.githubusercontent.com/trinker/textreadr/master/inst/docs/trans7.rtf'
)
}
}
\seealso{
\code{\link[striprtf:read_rtf]{striprtf::read_rtf()}}
}
\keyword{rtf}
