% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cem_match.R
\name{cem_match}
\alias{cem_match}
\title{Match using CEM}
\usage{
cem_match(
  theta,
  projection,
  treat,
  topic_breaks = c(0, 0.1, 1),
  projection_breaks = 5,
  returnX = FALSE,
  ...
)
}
\arguments{
\item{theta}{an output of \code{\link{refit}} containing the refit topic proportions, theta.
If given the argument \code{NULL} the function will omit matching on topics.}

\item{projection}{an output of \code{\link{project}} containing the projection. If given
the argument \code{NULL} the function will omit matching on the projection.}

\item{treat}{the treatment variable.}

\item{topic_breaks}{the cutpoints used for the topics. If this is a vector it defines the 
vector of cutpoints.  If this is a single number, it determines the number of bins.  By default
it uses the cutpoints \code{0,.1,1} which corresponds to bins of less than 10% about a topic
and more than 10\% about a topic.}

\item{projection_breaks}{the cutpoints used for the projection. If this is a vector it defines the 
vector of cutpoints.  If this is a single number, it determines the number of bins.  By default
it uses 5 inductively learned bins. See \pkg{cem} for more details.}

\item{returnX}{a logical which if true adds a copy of the data to the return object as a top level
item in the list called \code{X}.}

\item{...}{additional arguments passed to \link[cem]{cem}}
}
\value{
a \code{cem.match} object
}
\description{
A wrapper around CEM to match on refit topics and projection.
}
\details{
This function is a convenience wrapper around CEM which returns a \pkg{cem} object.
}
\examples{
\donttest{
#See ?sim for a walkthrough
data(sim)
refitted <- refit(sim_topics, sim_documents, content_level="1")
projection <- project(sim_topics, sim_documents)
matched <- cem_match(refitted,projection=projection, sim_meta$treat,
                     projection_breaks=2)
}
}
