% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perplexity.R
\name{perplexity}
\alias{perplexity}
\title{Perplexity of a topic model}
\usage{
perplexity(X, topic_word_distribution, doc_topic_distribution)
}
\arguments{
\item{X}{sparse document-term matrix which contains terms counts. Internally \code{Matrix::RsparseMatrix} is used.
If \code{!inherits(X, 'RsparseMatrix')} function will try to coerce \code{X} to \code{RsparseMatrix}
via \code{as()} call.}

\item{topic_word_distribution}{dense matrix for topic-word distribution. Number of rows = \code{n_topics},
number of columns = \code{vocabulary_size}. Sum of elements in each row should be equal to 1 -
each row is a distribution of words over topic.}

\item{doc_topic_distribution}{dense matrix for document-topic distribution. Number of rows = \code{n_documents},
number of columns = \code{n_topics}. Sum of elements in each row should be equal to 1 -
each row is a distribution of topics over document.}
}
\description{
Given document-term matrix, topic-word distribution, document-topic
distribution calculates perplexity
}
\examples{
library(text2vec)
data("movie_review")
n_iter = 10
train_ind = 1:200
ids = movie_review$id[train_ind]
txt = tolower(movie_review[['review']][train_ind])
names(txt) = ids
tokens = word_tokenizer(txt)
it = itoken(tokens, progressbar = FALSE, ids = ids)
vocab = create_vocabulary(it)
vocab = prune_vocabulary(vocab, term_count_min = 5, doc_proportion_min = 0.02)
dtm = create_dtm(it, vectorizer = vocab_vectorizer(vocab))
n_topic = 10
model = LDA$new(n_topic, doc_topic_prior = 0.1, topic_word_prior = 0.01)
doc_topic_distr  =
  model$fit_transform(dtm, n_iter = n_iter, n_check_convergence = 1,
                      convergence_tol = -1, progressbar = FALSE)
topic_word_distr_10 = model$topic_word_distribution
perplexity(dtm, topic_word_distr_10, doc_topic_distr)
}
