% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabulary.R
\name{vocabulary}
\alias{vocabulary}
\alias{vocabulary.character}
\alias{vocabulary.itoken}
\title{Creates vocabulary (unique terms)}
\usage{
vocabulary(src, ngram = c(ngram_min = 1L, ngram_max = 1L), ...)

\method{vocabulary}{character}(src, ngram = c(ngram_min = 1L, ngram_max = 1L),
  ...)

\method{vocabulary}{itoken}(src, ngram = c(ngram_min = 1L, ngram_max = 1L),
  serialize_dir = NULL, ...)
}
\arguments{
\item{src}{iterator over \code{list} of \code{character} vectors - documents from which
user want construct vocabulary. Or, alternatively,
\code{character} vector = user-defined vocabulary terms (which will be used "as is").}

\item{ngram}{\code{integer} vector. The lower and upper boundary of the range of
n-values for different n-grams to be extracted. All values of n such that
ngram_min <= n <= ngram_max will be used.}

\item{...}{arguments passed to other methods (inculding \link{write_rds} function).}

\item{serialize_dir}{As a \bold{side effect}, we can save tokenized texts in serialized form to disk.
So, \code{serialize_dir} is a \code{character} - path where to save tokenized input files.}
}
\value{
\code{text2vec_vocabulary} object,
which is actually a \code{list} with following fields:

1. \bold{vocab} - \code{data.frame} which contains columns
\itemize{
 \item{\code{terms}       }{ \code{character} vector of unique terms}
 \item{\code{terms_counts} }{ \code{integer} vector of term counts across all documents}
 \item{\code{doc_counts}  }{ \code{integer} vector of document counts
                           that contain corresponding term}
 \item{\code{doc_proportions}   }{ \code{numeric} vector of document proportions
                           that contain corresponding term}
}

2. \bold{ngram} - \code{integer} vector, the lower and upper boundary of the range of n-gram-values.
}
\description{
collects unique terms and corresponding statistics from object.
See \code{value} section.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: creates \code{text2vec_vocabulary} from predefined
character vector. Terms will be inserted \bold{as is}, without any checks
(ngrams numner, ngram delimiters, etc.).

\item \code{itoken}: collects unique terms and corresponding statistics from object.
}}
\examples{
data("movie_review")
txt <- movie_review[['review']][1:100]
it <- itoken(txt, tolower, word_tokenizer, chunks_number = 10)
vocab <- vocabulary(it)
pruned_vocab = prune_vocabulary(vocab, term_count_min = 10,
 doc_proportion_max = 0.8, doc_proportion_min = 0.001, max_number_of_terms = 20000)
}

