% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{check_markdown_file}
\alias{check_markdown_file}
\title{check markdown file}
\usage{
check_markdown_file(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
FALSE if markdown file is corrupted/empty else TRUE
}
\description{
Checks if the markdown file generated is empty or not due to some pandoc
related error during conversion to markdown.
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
rmarkdown::pandoc_version()
texor::include_style_file(your_article_path)
rebib::aggregate_bibliography(your_article_path)
texor::convert_to_markdown(your_article_path)
texor::check_markdown_file(your_article_path)
unlink(your_article_folder, recursive = TRUE)
}
