% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{expect_snapshot_output}
\alias{expect_snapshot_output}
\alias{expect_snapshot_error}
\alias{expect_snapshot_warning}
\title{Snapshot helpers}
\usage{
expect_snapshot_output(x, cran = FALSE, variant = NULL)

expect_snapshot_error(x, class = "error", cran = FALSE, variant = NULL)

expect_snapshot_warning(x, class = "warning", cran = FALSE, variant = NULL)
}
\arguments{
\item{x}{Code to evaluate.}

\item{cran}{Should these expectations be verified on CRAN? By default,
they are not, because snapshot tests tend to be fragile because they
often rely on minor details of dependencies.}

\item{variant}{If non-\code{NULL}, results will be saved in
\verb{_snaps/\{variant\}/\{test.md\}}, so \code{variant} must be a single string
suitable for use as a directory name.

You can use variants to deal with cases where the snapshot output varies
and you want to capture and test the variations. Common use cases include
variations for operating system, R version, or version of key dependency.
Variants are an advanced feature. When you use them, you'll need to
carefully think about your testing strategy to ensure that all important
variants are covered by automated tests, and ensure that you have a way
to get snapshot changes out of your CI system and back into the repo.}

\item{class}{Class of expected error or warning. The expectation will
always fail (even on CRAN) if an error of this class isn't seen
when executing \code{x}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

These snapshotting functions are questioning because they were developed
before \code{\link[=expect_snapshot]{expect_snapshot()}} and we're not sure that they still have a
role to play.
\itemize{
\item \code{expect_snapshot_output()} captures just output printed to the console.
\item \code{expect_snapshot_error()} captures an error message and
optionally checks its class.
\item \code{expect_snapshot_warning()} captures a warning message and
optionally checks its class.
}
}
\keyword{internal}
