% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tessdata.R
\name{tesseract_download}
\alias{tesseract_download}
\alias{tessdata}
\alias{tesseract_info}
\title{Tesseract Training Data}
\usage{
tesseract_download(lang, datapath = NULL, progress = TRUE)

tesseract_info()
}
\arguments{
\item{lang}{three letter code for language, see \href{https://github.com/tesseract-ocr/tessdata}{tessdata} repository.}

\item{datapath}{destination directory where to download store the file}

\item{progress}{print progress while downloading}
}
\description{
Helper function to download training data from the official
\href{https://github.com/tesseract-ocr/tessdata}{tessdata} repository. Only use this function on
Windows and OS-X. On Linux, training data can be installed directly with
\href{https://apps.fedoraproject.org/packages/tesseract}{yum} or
\href{https://packages.debian.org/search?suite=stable&section=all&arch=any&searchon=names&keywords=tesseract-ocr-}{apt-get}.
}
\examples{
\dontrun{
tesseract_download("fra")
french <- tesseract("fra")
text <- ocr("http://ocrapiservice.com/static/images/examples/french_text.png", engine = french)
cat(text)
}
}

