% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{c_label_n_alt}
\alias{c_label_n_alt}
\title{Content Row Function to Add \code{alt_counts_df} Row Total to Labels}
\usage{
c_label_n_alt(df, labelstr, .alt_df_row)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}
}
\value{
A list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}} with the row count value and the correct label.
}
\description{
This takes the label of the latest row split level and adds the row total from \code{alt_counts_df}
in parentheses. This function differs from \code{\link[=c_label_n]{c_label_n()}} by taking row counts from \code{alt_counts_df}
rather than \code{df}, and is used by \code{\link[=add_rowcounts]{add_rowcounts()}} when \code{alt_counts} is set to \code{TRUE}.
}
\seealso{
\code{\link[=c_label_n]{c_label_n()}} which performs the same function but retrieves row counts from \code{df} instead
of \code{alt_counts_df}.
}
\keyword{internal}
