% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_time.R
\name{survival_time}
\alias{survival_time}
\alias{s_surv_time}
\alias{a_surv_time}
\alias{surv_time}
\title{Survival Time Analysis}
\usage{
s_surv_time(df, .var, is_event, control = control_surv_time())

a_surv_time(df, .var, is_event, control = control_surv_time())

surv_time(
  lyt,
  vars,
  ...,
  var_labels = "Time to Event",
  table_names = vars,
  .stats = c("median", "median_ci", "quantiles", "range_censor", "range_event"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = c(median = 0L, median_ci = 1L, quantiles = 0L, range_censor = 0L,
    range_event = 0L, range = 0L)
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{is_event}{(\code{logical})\cr \code{TRUE} if event, \code{FALSE} if time to event is censored.}

\item{control}{(\code{list})\cr parameters for comparison details, specified by using the helper function
\code{\link[=control_surv_time]{control_surv_time()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for survival time.
\item \code{conf_type} (\code{string})\cr confidence interval type. Options are "plain" (default), "log", or "log-log",
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note option "none" is not supported.
\item \code{quantiles} (\code{numeric})\cr vector of length two to specify the quantiles of survival time.
}}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{...}{additional arguments for the lower level functions.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
\itemize{
\item \code{s_surv_time()} returns the statistics:
\itemize{
\item \code{median}: Median survival time.
\item \code{median_ci}: Confidence interval for median time.
\item \code{quantiles}: Survival time for two specified quantiles.
\item \code{range_censor}: Survival time range for censored observations.
\item \code{range_event}: Survival time range for observations with events.
\item \code{range}: Survival time range for all observations.
}
}

\itemize{
\item \code{a_surv_time()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{surv_time()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_surv_time()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize median survival time and CIs, percentiles of survival times, survival
time range of censored/event patients.
}
\section{Functions}{
\itemize{
\item \code{s_surv_time()}: Statistics function which analyzes survival times.

\item \code{a_surv_time()}: Formatted analysis function which is used as \code{afun} in \code{surv_time()}.

\item \code{surv_time()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
library(dplyr)

adtte_f <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(
    AVAL = day2month(AVAL),
    is_event = CNSR == 0
  )
df <- adtte_f \%>\% filter(ARMCD == "ARM A")

basic_table() \%>\%
  split_cols_by(var = "ARMCD") \%>\%
  add_colcounts() \%>\%
  surv_time(
    vars = "AVAL",
    var_labels = "Survival Time (Months)",
    is_event = "is_event",
    control = control_surv_time(conf_level = 0.9, conf_type = "log-log")
  ) \%>\%
  build_table(df = adtte_f)

}
\keyword{internal}
