% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkexptab}
\alias{checkexptab}
\title{Check Validity of Experiment Table}
\usage{
checkexptab(exptab)
}
\arguments{
\item{exptab}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}
}
\value{
If the experiment table is valid, the function returns `NULL`. If the table
is invalid, the function throws an error specifying the issue.
}
\description{
The `checkexptab` function verifies the structure and content of an
experiment table to ensure it meets specific formatting requirements. It
checks for the presence of required columns, and validates that the
`direction` and `strand` columns contain only allowable values.
}
\details{
The function performs the following checks:
- The column names of `exptab` must match exactly: `"condition"`,
 `"replicate"`, `"direction"`, and `"strand"`.
- The `direction` column must contain only `"forward"` and `"reverse"`.
- The `strand` column must contain only `"plus"` and `"minus"`.
}
\examples{
# Create a valid experiment table
exptab <- data.frame(
  condition = c("cond1", "cond2"),
  replicate = c(1, 1),
  direction = c("forward", "reverse"),
  strand = c("plus", "minus"),
  path = c("toto/", "toto/"))
checkexptab(exptab)  # Should pass without errors

# Invalid experiment table (wrong column names)
invalid_exptab <- data.frame(
    cond = c("cond1", "cond2"),
    rep = c(1, 1),
    dir = c("forward", "reverse"),
    str = c("+", "-"),
    paths = c("toto/", "toto/"))
try(checkexptab(invalid_exptab))

}
