% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{tmpl}
\alias{tmpl}
\alias{tmpl.character}
\alias{tmpl.formula}
\alias{tmpl.function}
\alias{tmpl.tmpl}
\title{Template constructors}
\usage{
tmpl(.t, ...)

\method{tmpl}{character}(.t, ..., .envir = parent.frame())

\method{tmpl}{formula}(.t, ...)

\method{tmpl}{tmpl}(.t, ...)

\method{tmpl}{function}(.t, ...)
}
\arguments{
\item{.t}{something that can be interpreted as template. See defined methods
for options.}

\item{...}{(name = value | name ~ value) name-value expressions passed on to
\link{tmplUpdate}}

\item{.envir}{(environment) the environment in which template snippets are
evaluated. For \code{formula}s and \code{function}s their environment is
used.}
}
\description{
\code{tmpl} is the constructor function for template objects.
}
\details{
Objects of class \code{tmpl} are stored as a character of length
  one. They can contain 'snippets' to be evaluated. These snippets are
  identified by an opening \code{\{\{} and closing \code{\}\}}. The
  environment in which they are evaluated is stored in the object. They can
  be further augmented by supplying arguments in \code{...}.
}
\examples{

tmpl("Hi {{ toupper(a) }}!", a = "there")
tmpl( ~ {y <- {{ a }}}, a ~ x + 1)
tmpl(function(x) {{ a }} + x, a ~ 1)

}
\seealso{
\link{tmplUpdate}, \link{tmplEval}
}

