% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{setWebhook}
\alias{setWebhook}
\title{Set a webhook}
\usage{
setWebhook(
  url = NULL,
  certificate = NULL,
  max_connections = 40L,
  allowed_updates = NULL
)
}
\arguments{
\item{url}{HTTPS url to send updates to. Use an empty string to remove
webhook integration.}

\item{certificate}{(Optional). Upload your public key certificate so that
the root certificate in use can be checked. See Telegram's
\href{https://core.telegram.org/bots/self-signed}{self-signed guide} for
details.}

\item{max_connections}{(Optional). Maximum allowed number of simultaneous
HTTPS connections to the webhook for update delivery, 1-100. Defaults to
40. Use lower values to limit the load on your bot's server, and higher
values to increase your bot's throughput.}

\item{allowed_updates}{(Optional). String or vector of strings with the
    types of updates you want your bot to receive. For example, specify
    \code{c("message", "edited_channel_post", "callback_query")} to only
    receive updates of these types. See
    \href{https://core.telegram.org/bots/api#update}{Update}
    for a complete list of available update types. Specify an empty string
    to receive all updates regardless of type (default). If not specified,
    the previous setting will be used.

    Please note that this parameter doesn't affect updates created before
    the call to the get_updates, so unwanted updates may be received for a
    short period of time.}
}
\description{
Use this method to specify a url and receive incoming updates via an
outgoing webhook. Whenever there is an update for the bot, we will send an
HTTPS POST request to the specified url, containing a JSON-serialized
\href{https://core.telegram.org/bots/api#update}{Update}.
}
\details{
If you'd like to make sure that the webhook request comes from Telegram, we
recommend using a secret path in the URL, e.g.
\code{https://www.example.com/<token>}.

You can also use it's snake_case equivalent \code{set_webhook}.
}
