% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{get_theta_null}
\alias{get_theta_null}
\title{Permute a dataset under the null hypothesis and get the MNPP}
\usage{
get_theta_null(data, Trt, Y, zbar, step1, step2, ...)
}
\arguments{
\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{zbar}{the estimated marginal treatment effect}

\item{step1}{character strings specifying the Step 1 model. Supports
either "\code{lasso}", "\code{mars}", "\code{randomforest}", or
"\code{superlearner}".}

\item{step2}{a character string specifying the Step 2 model. Supports
"\code{lasso}", "\code{rtree}", or "\code{ctree}".}

\item{...}{additional arguments to the Step 1 model call.}
}
\value{
the MNPP for the permuted data set
}
\description{
Permute a dataset under the null hypothesis and get the MNPP
}
