% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_statistics.R
\name{roll_circstats}
\alias{roll_circstats}
\title{Apply Rolling Functions using Circular Statistics}
\usage{
roll_circstats(
  x,
  w = NULL,
  FUN,
  axial = TRUE,
  na.rm = TRUE,
  width = NULL,
  by.column = FALSE,
  partial = TRUE,
  fill = NA,
  ...
)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{FUN}{the function to be applied}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}

\item{width}{integer specifying the window width (in numbers of observations)
which is aligned to the original sample according to the \code{align} argument.
If \code{NULL}, an optimal width is calculated.}

\item{by.column}{logical. If \code{TRUE}, \code{FUN} is applied to each column
separately.}

\item{partial}{logical or numeric. If \code{FALSE} then \code{FUN} is only
applied when all indexes of the rolling window are within the observed time
range. If \code{TRUE} (default), then the subset of indexes that are in range
are passed to \code{FUN}. A numeric argument to partial can be used to determine
the minimal window size for partial computations. See below for more details.}

\item{fill}{a three-component vector or list (recycled otherwise) providing
filling values at the left/within/to the right of the data range. See the
fill argument of \code{\link[zoo:na.fill]{zoo::na.fill()}} for details}

\item{...}{optional arguments passed to \code{\link[zoo:rollapply]{zoo::rollapply()}}}
}
\value{
numeric vector  with the results of the rolling function.
}
\description{
A generic function for applying a function to rolling margins of an array.
}
\note{
If the rolling statistics are applied to values that are a function of
distance it is recommended to sort the values first.
}
\examples{
data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")
data("san_andreas")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
distance <- distance_from_pb(
  x = san_andreas,
  PoR = PoR,
  pb = plate_boundary,
  tangential = TRUE
)
dat <- san_andreas[order(distance), ]
roll_circstats(dat$azi, w = 1 / dat$unc, circular_mean, width = 51) |> head()
}
