% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{est.kappa}
\alias{est.kappa}
\title{Concentration parameter of von Mises distribution}
\usage{
est.kappa(x, w = NULL, bias = FALSE, ...)
}
\arguments{
\item{x}{numeric. angles in degrees}

\item{w}{numeric. weightings}

\item{bias}{logical parameter determining whether a bias correction is used
in the computation of the MLE. Default for bias is \code{FALSE} for no bias
correction.}

\item{...}{optional parameters passed to \code{circular_mean()}}
}
\value{
numeric.
}
\description{
Computes the maximum likelihood estimate of \eqn{\kappa}, the concentration
parameter of a von Mises distribution, given a set of angular measurements.
}
\examples{
est.kappa(rvm(100, 90, 10), w = 1 / runif(100, 0, 10))
}
