% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_filter_data.R
\name{module_filter_data}
\alias{module_filter_data}
\alias{ui_filter_data}
\alias{srv_filter_data}
\alias{.make_filtered_teal_data}
\alias{.observe_active_filter_changed}
\alias{.get_filter_expr}
\title{Filter panel module in teal}
\usage{
ui_filter_data(id)

srv_filter_data(id, datasets, active_datanames, data, is_active)

.make_filtered_teal_data(modules, data, datasets = NULL, datanames)

.observe_active_filter_changed(datasets, is_active, active_datanames, data)

.get_filter_expr(datasets, datanames)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{datasets}{(\code{reactive} returning \code{FilteredData} or \code{NULL})
When \code{datasets} is passed from the parent module (\code{srv_teal}) then \code{dataset} is a singleton
which implies the filter-panel to be "global". When \code{NULL} then filter-panel is "module-specific".}

\item{active_datanames}{(\code{reactive} returning \code{character}) this module's data names}

\item{data}{(\code{reactive} returning \code{teal_data})}

\item{modules}{(\code{teal_modules})
\code{teal_modules} object. These are the specific output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}
}
\value{
A \code{eventReactive} containing \code{teal_data} containing filtered objects and filter code.
\code{eventReactive} triggers only if all conditions are met:
\itemize{
\item tab is selected (\code{is_active})
\item when filters are changed (\code{get_filter_expr} is different than previous)
}
}
\description{
Creates filter panel module from \code{teal_data} object and returns \code{teal_data}. It is build in a way
that filter panel changes and anything what happens before (e.g. \code{\link{module_init_data}}) is triggering
further reactive events only if something has changed and if the module is visible. Thanks to
this special implementation all modules' data are recalculated only for those modules which are
currently displayed.
}
\keyword{internal}
