% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_with_settings.R
\name{plot_with_settings_ui}
\alias{plot_with_settings_ui}
\alias{plot_with_settings_srv}
\title{Plot-with-settings module}
\usage{
plot_with_settings_ui(id)

plot_with_settings_srv(
  id,
  plot_r,
  height = c(600, 200, 2000),
  width = NULL,
  show_hide_signal = reactive(TRUE),
  brushing = FALSE,
  clicking = FALSE,
  dblclicking = FALSE,
  hovering = FALSE,
  graph_align = "left"
)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module id.}

\item{plot_r}{(\code{reactive} or \code{function})\cr
\code{reactive} expression or a simple \code{function} to draw a plot.
A simple \code{function} is needed e.g. for base plots like \code{plot(1)} as the output can not be caught when downloading.
Take into account that simple functions are less efficient than reactive, as not catching the result.}

\item{height}{(\code{numeric}, optional)\cr
vector with three elements c(VAL, MIN, MAX), where VAL is the starting value of the slider in
the main and modal plot display. The value in the modal display is taken from the value of the
slider in the main plot display.}

\item{width}{(\code{numeric}, optional)\cr
vector with three elements \code{c(VAL, MIN, MAX)}, where VAL is the starting value of the slider in
the main and modal plot display; \code{NULL} for default display. The value in the modal
display is taken from the value of the slider in the main plot display.}

\item{show_hide_signal}{optional, (\code{reactive logical} a mechanism to allow modules which call this
module to show/hide the plot_with_settings UI)}

\item{brushing}{(\code{logical}, optional)\cr
a mechanism to enable / disable brushing on the main plot (in particular: not the one displayed
in modal). All the brushing data is stored as a reactive object in the \code{"brush"} element of
returned list. See the example for details.}

\item{clicking}{(\code{logical})\cr
a mechanism to enable / disable clicking on data points on the main plot (in particular: not the
one displayed in modal). All the clicking data is stored as a reactive object in the \code{"click"}
element of returned list. See the example for details.}

\item{dblclicking}{(\code{logical}, optional)\cr
a mechanism to enable / disable double-clicking on data points on the main plot (in particular:
not the one displayed in modal). All the double clicking data is stored as a reactive object in
the \code{"dblclick"} element of returned list. See the example for details.}

\item{hovering}{(\code{logical(1)}, optional)\cr
a mechanism to enable / disable hovering over data points on the main plot (in particular: not
the one displayed in modal). All the hovering data is stored as a reactive object in the
\code{"hover"} element of returned list. See the example for details.}

\item{graph_align}{(\code{character(1)}, optional)\cr
one of \code{"left"} (default), \code{"center"}, \code{"right"} or \code{"justify"}. The alignment of the graph on
the main page.}
}
\value{
A \code{shiny} module.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Universal module for plots with settings for height, width, and download.
}
\details{
By default the plot is rendered with \verb{72 dpi}. In order to change this, to for example 96 set
\code{options(teal.plot_dpi = 96)}. The minimum allowed \code{dpi} value is \code{24} and it must be a whole number.
If an invalid value is set then the default value is used and a warning is outputted to the console.
}
\examples{
# Example using a reactive as input to plot_r
library(shiny)
app1 <- shinyApp(
  ui = fluidPage(
    plot_with_settings_ui(
      id = "plot_with_settings"
    )
  ),
  server = function(input, output, session) {
    plot_r <- reactive({
      ggplot2::qplot(x = 1, y = 1)
    })

    plot_with_settings_srv(
      id = "plot_with_settings",
      plot_r = plot_r,
      height = c(400, 100, 1200),
      width = c(500, 250, 750)
    )
  }
)

if (interactive()) {
  runApp(app1)
}

# Example using a function as input to plot_r
app2 <- shinyApp(
  ui = fluidPage(
    radioButtons("download_option", "Select the Option", list("ggplot", "trellis", "grob", "base")),
    plot_with_settings_ui(
      id = "plot_with_settings"
    ),
    sliderInput("nums", "Value", 1, 10, 1)
  ),
  server = function(input, output, session) {
    plot_r <- function() {
      numbers <- seq_len(input$nums)
      if (input$download_option == "ggplot") {
        ggplot2::ggplot(data.frame(n = numbers), ggplot2::aes(n)) +
          ggplot2::geom_bar()
      } else if (input$download_option == "trellis") {
        lattice::densityplot(numbers)
      } else if (input$download_option == "grob") {
        tr_plot <- lattice::densityplot(numbers)
        ggplot2::ggplotGrob(
          ggplot2::ggplot(data.frame(n = numbers), ggplot2::aes(n)) +
            ggplot2::geom_bar()
        )
      } else if (input$download_option == "base") {
        plot(numbers)
      }
    }

    plot_with_settings_srv(
      id = "plot_with_settings",
      plot_r = plot_r,
      height = c(400, 100, 1200),
      width = c(500, 250, 750)
    )
  }
)

if (interactive()) {
  runApp(app2)
}

# Example with brushing/hovering/clicking/double-clicking
app3 <- shinyApp(
  ui = fluidPage(
    plot_with_settings_ui(
      id = "plot_with_settings"
    ),
    fluidRow(
      column(4, h3("Brush"), verbatimTextOutput("brushing_data")),
      column(4, h3("Click"), verbatimTextOutput("clicking_data")),
      column(4, h3("DblClick"), verbatimTextOutput("dblclicking_data")),
      column(4, h3("Hover"), verbatimTextOutput("hovering_data"))
    )
  ),
  server = function(input, output, session) {
    plot_r <- reactive({
      ggplot2::qplot(x = 1:5, y = 1:5)
    })

    plot_data <- plot_with_settings_srv(
      id = "plot_with_settings",
      plot_r = plot_r,
      height = c(400, 100, 1200),
      brushing = TRUE,
      clicking = TRUE,
      dblclicking = TRUE,
      hovering = TRUE
    )

    output$brushing_data <- renderPrint(plot_data$brush())
    output$clicking_data <- renderPrint(plot_data$click())
    output$dblclicking_data <- renderPrint(plot_data$dblclick())
    output$hovering_data <- renderPrint(plot_data$hover())
  }
)

if (interactive()) {
  runApp(app3)
}

# Example which allows module to be hidden/shown
library("shinyjs")

app4 <- shinyApp(
  ui = fluidPage(
    useShinyjs(),
    actionButton("button", "Show/Hide"),
    plot_with_settings_ui(
      id = "plot_with_settings"
    )
  ),
  server = function(input, output, session) {
    plot_r <- reactive(ggplot2::qplot(data = faithful, x = waiting, y = eruptions))

    show_hide_signal_rv <- reactiveVal(TRUE)

    observeEvent(input$button, show_hide_signal_rv(!show_hide_signal_rv()))

    plot_with_settings_srv(
      id = "plot_with_settings",
      plot_r = plot_r,
      height = c(400, 100, 1200),
      width = c(500, 250, 750),
      show_hide_signal = reactive(show_hide_signal_rv())
    )
  }
)

if (interactive()) {
  runApp(app4)
}

}
