ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),

sidebarLayout(
  sidebarPanel(width = 3, 
  hr(),
  sliderInput("range.lev", 
              label = "Range",
              min = -20, 
              max = 20, 
              value = c(-6,6)),
  hr(),
  sliderInput("mu.lev", 
              label = HTML("Mean (&mu;)"),
              min = -3, 
              max = 3, 
              step = 0.5, 
              value = 0, 
              animate = T),
  hr(),
  sliderInput("sig.lev", 
              label = HTML("Std Dev (&sigma;)"),
              min = 1, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = T)),

mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',
           metricsgraphicsOutput('levC')),
  tabPanel('Density',
           metricsgraphicsOutput('levP')),
  tabPanel('Survival',
           metricsgraphicsOutput('levR')),
  tabPanel('Hazard',
           metricsgraphicsOutput('levh')),
  tabPanel('Cumulative Hazard',
           metricsgraphicsOutput('levH')),
  tabPanel('Quantile',
           metricsgraphicsOutput('levQ'))))))
