\name{PS}
\alias{PS}
\title{
Sample Path Stability Algorithm
}
\description{
An Implementation of the heuristic algorithm for choosing the optimal sample fraction proposed in Caeiro & Gomes (2016), among others.
}
\usage{
PS(data, j = 1)
}
\arguments{
  \item{data}{
vector of sample data
}
  \item{j}{
digits to round to. Should be \code{0} or \code{1} (default). 
}
}
\details{
The algorithm searches for a stable region of the sample path, i.e. the plot of a tail index estimator with respect to \code{k}. This is done in two steps. First the estimation of the tail index for every \code{k} is rounded to \code{j} digits and the longest set of equal consecutive values is chosen. For this set the estimates are rounded to \cite{j+2} digits and the mode of this subset is determined. The corresponding biggest k-value, denoted \code{k0} here, is the optimal number of data in the tail. 
}
\value{
\item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
  \item{threshold}{the corresponding threshold}
  \item{tail.index}{the corresponding tail index}
}
\references{
Caeiro, J. and Gomes, M.I. (2016)
Threshold selection in extreme value analysis.
\emph{Extreme Value Modeling and Risk Analysis:Methids and Applications}, 69--86.

Gomes, M.I. and Henriques-Rodrigues, L. and Fraga Alves, M.I. and Manjunath, B. (2013)
Adaptive PORT-MVRB estimation: an empirical comparison of two heuristic algorithms.
\emph{Journal of Statistical Computation and Simulation}, \bold{83}, 1129--1144.

Gomes, M.I. and Henriques-Rodrigues, L. and Miranda, M.C. (2011)
Reduced-bias location-invariant extreme value index estimation: a simulation study.
\emph{Communications in Statistic-Simulation and Computation}, \bold{40}, 424--447.
}
\examples{
data(danish)
PS(danish)
}